@extends(BaseHelper::getAdminMasterLayoutTemplate())
@section('content')
    <div class="flexbox-grid">
        <div class="flexbox-content">
            <div class="body">
                <div class="box-wrap-emptyTmpl text-center col-12">
                    <h1 class="mt20 mb20 ws-nm font-size-emptyDisplayTmpl">
                        {{ trans('plugins/ecommerce::products.manage_products') }}</h1>
                    <p class="text-info-displayTmpl">{{ trans('plugins/ecommerce::products.start_by_adding_new_product') }}
                    </p>
                    <div class="empty-displayTmpl-pdtop">
                        <div class="empty-displayTmpl-image">
                            <svg
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 518 270"
                            >
                                <path
                                    fill="#D3DCE6"
                                    d="M409.064 190.02h-137.98a.992.992 0 0 1-.994-.993V.994c0-.55.445-.994.995-.994h137.98c.55 0 .994.445.994.994v188.033c0 .55-.45.994-1 .994zm-136.985-1.987h135.99V1.988H272.08v186.045z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M402.792 183.256H277.357a.496.496 0 0 1-.497-.497V7.26c0-.274.222-.496.497-.496h125.436c.275 0 .497.222.497.497v175.5c0 .28-.223.5-.498.5zm-124.938-.994h124.44V7.758h-124.44v174.504z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M271.085 189.524a.497.497 0 0 1-.352-.85l6.272-6.267a.497.497 0 0 1 .703.703l-6.272 6.268a.495.495 0 0 1-.35.146zm137.98 0a.504.504 0 0 1-.353-.146l-6.272-6.268a.497.497 0 0 1 .703-.703l6.272 6.268a.497.497 0 0 1-.35.85zM402.79 7.758a.497.497 0 0 1-.352-.85L408.71.64a.496.496 0 1 1 .703.702L403.14 7.61a.487.487 0 0 1-.35.145zm-125.435 0a.504.504 0 0 1-.352-.146l-6.272-6.267a.505.505 0 0 1 0-.703c.2-.194.51-.194.71 0l6.27 6.267c.2.19.2.5 0 .7a.46.46 0 0 1-.35.14zM342.19 109.39l-51.13-37.237 53.168-44.682 34.462 71.5-36.5 10.43zm-49.518-37.293l49.713 36.205 34.896-9.968-33.39-69.278-51.21 43.04z"
                                ></path>
                                <path
                                    fill="#F7F8FC"
                                    d="M393.384 173.855h-106.62a.496.496 0 0 1-.497-.497V16.663c0-.275.222-.497.497-.497h106.62c.275 0 .497.222.497.497v156.695c0 .274-.22.497-.49.497zm-106.123-.994h105.63V17.16H287.26v155.7z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M466.68 105.932c-.017 0-.035 0-.052-.003-1.3-.14-2.594-.29-3.89-.45a.503.503 0 0 1-.434-.56c.033-.28.29-.46.554-.44 1.29.15 2.583.3 3.876.44.273.03.47.27.442.54a.5.5 0 0 1-.495.44zm-11.112-1.43c-.02 0-.043 0-.064-.003-13.61-1.76-28.358-2.02-46.41-.83a.506.506 0 0 1-.53-.47.496.496 0 0 1 .463-.53c18.12-1.2 32.93-.93 46.603.83a.493.493 0 1 1-.062.98zm-200.55 6.532c-29.365 0-61.357-1.848-97.294-10.136-15.404-3.297-25.412-.17-36.006 3.14-7.268 2.272-14.784 4.62-24.683 5.304a.507.507 0 0 1-.53-.462.495.495 0 0 1 .46-.53c9.784-.675 17.242-3.006 24.456-5.26 10.73-3.35 20.86-6.518 36.52-3.163 42.51 9.802 79.5 10.576 113.14 9.95h.01c.27 0 .49.217.5.49.01.273-.21.5-.49.505-5.27.098-10.63.162-16.07.162zm225.478 15.613c-.016 0-.03 0-.047-.002-4-.368-7.94-.78-10.93-1.1a.49.49 0 0 1-.44-.547c.03-.274.29-.47.54-.442 2.98.318 6.91.73 10.9 1.098.27.025.47.267.45.54a.502.502 0 0 1-.5.453zm-23.19-2.415c-.016 0-.034 0-.05-.003-14.628-1.53-31.618-3.01-48.144-1.3a.503.503 0 0 1-.103-1c16.61-1.73 33.67-.24 48.34 1.29.27.02.47.27.44.54-.03.25-.25.44-.5.44zM163.61 145.36c-9.327 0-16.91-3-25.238-6.288-12.926-5.11-27.577-10.897-53.713-8.424a.503.503 0 0 1-.55-.448.492.492 0 0 1 .45-.542c26.37-2.496 41.14 3.34 54.17 8.49 13.1 5.176 23.44 9.263 41.3 3.316l1.02-.39c29.08-11.026 59.16-22.426 90.13-14.95.26.066.43.334.36.6a.5.5 0 0 1-.6.368c-30.69-7.408-60.61 3.94-89.55 14.912l-1.05.397c-6.33 2.11-11.79 2.96-16.76 2.96zm304.996-30.297c-.015 0-.03 0-.043-.002l-2.598-.22c-18.635-1.59-37.903-3.23-56.87-1.95a.503.503 0 0 1-.53-.46.498.498 0 0 1 .46-.53c19.043-1.28 38.35.36 57.024 1.96l2.59.22c.27.03.47.27.45.54-.03.26-.24.46-.5.46z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M67.383 119.096c-5.473 0-11.248-.25-17.36-.826a.496.496 0 0 1-.448-.54.495.495 0 0 1 .542-.45c28.364 2.674 49.51-1.75 66.502-5.305 15.47-3.238 27.69-5.794 39.84-2.327 34.55 7.08 69.02 7.053 102.36 7.018 4.08-.003 8.17-.007 12.26 0 .27 0 .49.225.49.5 0 .273-.23.495-.5.495h-12.26c-33.4.03-67.92.07-102.6-7.04-11.95-3.41-24.06-.87-39.4 2.34-13.4 2.81-29.38 6.15-49.44 6.15zm405.395 13.78h-.02c-18.928-.805-41.296-1.472-63.672-.346-.316.03-.51-.198-.522-.47a.494.494 0 0 1 .47-.522c22.422-1.13 44.816-.46 63.765.344a.497.497 0 0 1-.03.994zM163.312 149.94c-18.922 0-33.072-4.283-45.81-8.136-9.947-3.01-19.342-5.85-29.942-6.5a.497.497 0 0 1-.466-.526.49.49 0 0 1 .527-.466c10.72.655 20.17 3.514 30.17 6.54 15.95 4.823 32.43 9.81 57.39 7.545 9.91-1.415 16.2-3.37 22.86-5.44 13.38-4.16 27.21-8.46 72.32-8.46h.74a.498.498 0 0 1 .01.995h-.74c-44.96 0-58.71 4.276-72.02 8.413-6.7 2.082-13.02 4.05-23.03 5.48-4.2.382-8.18.554-11.98.554zm-1.495-18.14c-1.453 0-2.953-.065-4.483-.2-5.078-.447-10.77-1.762-12.04-3.693-.467-.712-.325-1.477.39-2.1.854-.743 1.722-1.053 2.658-.952.273.03.47.276.44.548a.505.505 0 0 1-.55.44c-.652-.074-1.253.156-1.895.714-.434.378-.342.604-.21.804 1.685 2.57 18.784 5.62 27.982 1.23.25-.12.3-.2.3-.2-.56-1.9-21.86-6.38-44.67-4.29-.29.02-.52-.17-.54-.45-.03-.27.17-.51.45-.54 21-1.92 44.84 1.91 45.71 5.07.08.31.09.88-.83 1.32-3.17 1.52-7.66 2.32-12.73 2.32z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M166.776 133.957c-12.6 0-25.534-3.267-38.23-6.475a971.82 971.82 0 0 0-4.955-1.244.505.505 0 0 1-.36-.602c.07-.267.34-.43.61-.363 1.65.408 3.3.825 4.96 1.245 22.69 5.73 46.15 11.658 66.86-1.447.32-.19.29-.51.27-.6a.533.533 0 0 0-.45-.45c-46.36-9.42-49.13-9.05-75.62-5.48-11.66 1.58-27.63 3.73-53.84 5.94a.493.493 0 0 1-.53-.45c-.02-.27.18-.51.46-.53 26.19-2.2 42.15-4.35 53.8-5.93 26.64-3.59 29.43-3.97 75.96 5.49.64.13 1.11.61 1.23 1.26.12.64-.16 1.28-.71 1.63-9.38 5.94-19.29 8.05-29.4 8.05zm-110.23-9.27c-.73 0-1.46-.005-2.19-.014a.497.497 0 0 1-.49-.503c0-.275.234-.543.503-.49 1.35.016 2.72.017 4.08.002.27 0 .49.22.49.492a.5.5 0 0 1-.49.502c-.64.007-1.28.01-1.92.01zm352.514 52.177a.497.497 0 0 1-.007-.994c11.81-.153 23.814-.472 35.423-.78 17.403-.46 35.396-.93 53.11-.87.275 0 .496.224.495.5 0 .273-.22.494-.49.494-17.69-.058-35.68.41-53.08.87-11.61.308-23.62.626-35.43.78zm72.17-34.664c-.017 0-.032-.002-.048-.003-2.746-.25-5.492-.514-8.237-.777a.5.5 0 0 1-.448-.543c.027-.274.28-.458.543-.447 2.743.263 5.487.525 8.233.777a.498.498 0 0 1-.044.992zm-15.788-1.5h-.048c-1.654-.157-3.313-.318-4.978-.48-16.953-1.645-34.482-3.348-51.268-.35a.502.502 0 0 1-.577-.403.51.51 0 0 1 .41-.577c16.92-3.02 34.52-1.31 51.54.34 1.67.162 3.32.322 4.98.48a.49.49 0 0 1 .45.54.492.492 0 0 1-.49.45zm-194.427 25.693c-7.35-1.043-14.89-2.113-22.247-3.574-7.034-1.39-13.758-3.54-20.26-5.62-5.328-1.7-10.837-3.46-16.394-4.75-2.01-.47-3.59-1.85-3.6-3.15-.004-.49.22-1.38 1.762-1.76 17.467-4.33 37.923-6.72 60.8-7.1h.01c.27 0 .49.21.496.49.005.27-.215.5-.49.5-22.802.37-43.183 2.75-60.577 7.06-.462.11-1.01.34-1.008.78.005.72 1.217 1.81 2.83 2.18 5.597 1.3 11.126 3.07 16.472 4.77 6.47 2.06 13.17 4.2 20.15 5.58 7.33 1.45 14.85 2.52 22.14 3.56l-.02.5-.07.49z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M271.086 158.982a.474.474 0 0 1-.075-.006c-10.64-1.596-24.65-3.715-38.57-5.945-2.1-.33-3.98-2.51-3.89-3.95.05-.81.66-1.32 1.64-1.36 13.96-.58 28.57-1.13 40.9-1.25.24-.03.5.22.51.49.01.28-.22.5-.49.5-12.32.13-26.92.68-40.86 1.26-.66.03-.68.31-.69.43-.05.9 1.41 2.65 3.06 2.91 13.92 2.23 27.93 4.35 38.57 5.95.28.04.46.3.42.57-.04.25-.25.43-.49.43zm217.457-5.485h-.03c-1.342-.08-2.686-.177-4.028-.288a.507.507 0 0 1-.455-.54c.023-.28.286-.47.536-.46 1.335.11 2.67.2 4.006.28a.49.49 0 0 1 .467.52c-.02.26-.24.46-.5.46zm-10.003-.88c-.018 0-.038 0-.056-.003-6.93-.795-14.15-2.27-21.134-3.697-15.987-3.267-32.516-6.645-48.167-2.663a.494.494 0 0 1-.604-.36.494.494 0 0 1 .35-.603c15.87-4.03 32.51-.63 48.61 2.66 6.96 1.42 14.16 2.9 21.05 3.69.27.03.47.28.43.55-.03.26-.25.44-.5.44zm-38.113 9.806h-.086a833.408 833.408 0 0 1-31.32-2.05.5.5 0 0 1-.45-.538c.03-.274.29-.47.54-.453a828.36 828.36 0 0 0 31.29 2.047c.66-.01.75-.54.76-.66.04-.28-.06-.77-.61-.87-4.54-.88-9.17-1.58-13.77-2.09a.502.502 0 0 1-.44-.55c.03-.28.28-.47.55-.44 4.63.52 9.29 1.22 13.86 2.1 1.05.2 1.51 1.14 1.41 1.96-.11.91-.8 1.53-1.71 1.53z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M446.514 164.998c-17.028 0-35.418-.564-37.47-.628a.498.498 0 0 1-.48-.513.51.51 0 0 1 .512-.48c29.63.933 61.915.952 64.698-.81-.2-.14-.722-.416-2.05-.802-20.995-5.54-44.806-11.825-62.477-4.718a.497.497 0 0 1-.647-.276.49.49 0 0 1 .276-.64c17.98-7.23 41.96-.9 63.115 4.68 2.19.64 2.99 1.16 2.87 1.89-.12.8-.36 2.29-28.07 2.3h-.27zm37.11-1.468a.498.498 0 0 1-.006-.995c4.33-.076 8.66-.146 12.993-.21.23-.005.5.216.51.49a.49.49 0 0 1-.49.505c-4.33.063-8.66.133-12.99.21h-.01zm12.323 19.916a.497.497 0 0 1-.496-.47.504.504 0 0 1 .47-.523c1.38-.078 2.76-.158 4.13-.24.27-.023.51.193.53.467a.49.49 0 0 1-.46.525c-1.37.082-2.75.162-4.13.24h-.03zm-79.604 2.244c-2.43 0-4.86-.007-7.286-.02a.496.496 0 0 1 .003-.993h.003c26.78.14 53.927-.496 80.658-1.887.29-.02.51.196.53.47.02.275-.19.51-.47.522a1415.928 1415.928 0 0 1-73.43 1.908zm-145.257-10.158a.622.622 0 0 1-.105-.01c-16.69-3.578-25.27-6.477-32.17-8.806-14.44-4.878-22.4-7.564-82.07-10.08-28.04-1.185-39.16-5.68-48.96-9.647-6.05-2.45-11.76-4.76-20.76-6.02a.496.496 0 0 1-.42-.56c.04-.28.29-.46.56-.43 9.13 1.27 14.9 3.6 21.01 6.07 9.73 3.93 20.76 8.4 48.64 9.57 59.82 2.52 67.82 5.22 82.35 10.13 6.88 2.32 15.43 5.21 32.07 8.77.27.06.44.32.38.59-.05.23-.25.39-.48.39zM42.928 141.88a.496.496 0 0 1-.03-.992c3.32-.194 6.69-.45 9.96-.7 4.6-.35 9.37-.714 14.07-.907.25 0 .5.21.51.48.01.28-.2.51-.48.52-4.69.19-9.44.56-14.04.91-3.27.25-6.65.51-9.98.7h-.03zM29.21 197.05a.498.498 0 0 1-.097-.985c9.012-1.82 17.5-5.823 25.71-9.693l1.566-.738c12.69-5.972 13.73-6.092 17.62-6.543 1.42-.16 3.2-.37 6.11-.93 5.8-1.13 9.05-5.16 12.49-9.42 1.29-1.6 2.62-3.25 4.11-4.76 1.07-1.09 2.56-2.1 4-3.07 2.54-1.72 5.18-3.5 5.35-5.65.1-1.28-.66-2.66-2.32-4.22-3.31-3.1-8.26-3.77-13.05-4.41-1.56-.21-3.02-.4-4.42-.68a.485.485 0 0 1-.39-.58c.05-.27.31-.45.58-.39 1.36.27 2.82.47 4.35.67 4.71.63 10.05 1.35 13.59 4.68 1.89 1.78 2.75 3.42 2.62 5.03-.21 2.62-3.05 4.54-5.79 6.4-1.4.94-2.84 1.92-3.85 2.95-1.46 1.48-2.78 3.11-4.05 4.69-3.56 4.41-6.92 8.57-13.08 9.77-2.95.58-4.74.78-6.18.95-3.76.44-4.77.55-17.31 6.46l-1.57.74c-8.26 3.896-16.81 7.92-25.94 9.77a.673.673 0 0 1-.1.01zm22.783-50.45a.497.497 0 0 1-.033-.994c2.138-.143 4.275-.31 6.41-.475 1.847-.14 3.693-.28 5.54-.41.266-.03.51.19.53.46.02.28-.187.52-.46.53-1.846.13-3.69.27-5.532.42-2.14.17-4.28.34-6.42.48h-.035z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M28.676 185.03a.497.497 0 0 1-.063-.99c13.576-1.73 20.188-6.4 26.02-10.51 4.5-3.17 8.75-6.17 15.404-7.11.474-.06.952-.13 1.43-.19 3.832-.5 7.795-1.03 10.65-3.91 1.7-1.71 2.4-3.68 1.925-5.39-.444-1.59-1.877-2.77-4.035-3.32a.488.488 0 0 1-.36-.6.51.51 0 0 1 .605-.36c2.52.64 4.205 2.07 4.75 4.02.574 2.07-.22 4.39-2.178 6.37-3.093 3.13-7.228 3.67-11.227 4.2-.474.06-.95.13-1.42.19-6.417.91-10.38 3.71-14.97 6.94-5.928 4.19-12.647 8.93-26.47 10.7l-.06.01zm5.676-28.394a.495.495 0 0 1-.07-.985c12.614-1.85 20.35-2.92 32.654-3.42.255-.01.506.21.517.48.01.28-.202.51-.477.52-12.254.5-19.97 1.57-32.55 3.42-.026.01-.05.01-.074.01zm391.752 52.72c-60.307 0-112.653-5.617-163.41-17.224-10.18.008-17.18 2.094-23.946 4.11-6.627 1.976-12.886 3.842-21.752 3.842-36 0-73.324-4.11-117.465-12.932-10.44-2.606-25.76 3.18-41.96 9.31-14.23 5.385-30.37 11.486-45.53 12.76a.497.497 0 0 1-.07-.99c15.02-1.26 31.09-7.33 45.26-12.69 17.07-6.45 31.82-12.03 42.54-9.35 44.06 8.81 81.32 12.91 117.25 12.91 8.72 0 14.91-1.84 21.47-3.8 6.85-2.04 13.93-4.15 24.29-4.15.04 0 .08.01.11.02 72.03 16.48 147.27 20.88 243.98 14.26a.502.502 0 0 1 .07 1c-28.65 1.96-55.43 2.96-80.8 2.96z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M10.623 222.315a.498.498 0 0 1-.493-.434.49.49 0 0 1 .43-.55c11.947-1.52 22.825-4.92 34.343-8.51 20.573-6.41 41.847-13.05 71.69-9.74 10.986 1.38 20.91 3.47 30.508 5.49 17.11 3.6 33.27 7.01 51.96 5.45 7.82-.9 15.15-1.97 22.23-3 28.55-4.16 53.2-7.75 92.32 2.02 66.74 11.95 129.53 7.98 195.99 3.78a.502.502 0 0 1 .07 1c-66.53 4.2-129.37 8.18-196.26-3.8-38.96-9.73-63.52-6.15-91.96-2.01-7.09 1.04-14.42 2.11-22.27 3.01-18.84 1.57-35.07-1.85-52.25-5.47-9.58-2.01-19.48-4.1-30.42-5.47-29.63-3.29-50.8 3.32-71.27 9.71-11.56 3.61-22.48 7.02-34.51 8.56h-.06z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M28.235 228.64a.497.497 0 0 1-.092-.985c7.715-1.464 15.672-3.387 23.367-5.246 21.878-5.29 44.502-10.76 66.842-7.32 30.75 4.73 62.56 6.11 94.542 4.09 16.914-1.07 26.705-2.5 34.572-3.65 15.238-2.23 22.885-3.35 60.948 2 30.664 4.31 62.336 6.91 94.137 7.74 33.61.87 67.76-.13 104.43-3.07.28-.02.52.18.54.45.03.27-.18.51-.45.53-36.7 2.94-70.89 3.95-104.53 3.07-31.84-.83-63.55-3.44-94.25-7.76-37.92-5.34-45.05-4.29-60.66-2.01-7.88 1.15-17.7 2.59-34.65 3.66-32.05 2.02-63.93.64-94.75-4.1-22.14-3.41-44.67 2.03-66.45 7.3-7.7 1.86-15.67 3.78-23.41 5.25-.03 0-.06.01-.09.01zm467.87 8.082a.495.495 0 0 1-.492-.447.496.496 0 0 1 .444-.545c6.384-.648 13.022-1.375 19.73-2.162.28-.032.52.163.553.436a.5.5 0 0 1-.436.552 1320.22 1320.22 0 0 1-19.805 2.166zm-475.685 6.45c-1.604 0-3.253-.045-4.966-.145a.496.496 0 0 1-.467-.525.485.485 0 0 1 .525-.467c9.665.568 17.382-.636 25.553-1.908 7.17-1.116 14.582-2.27 23.752-2.27 14.926-2.494 36.245-2.194 60.93-1.846 29.153.42 62.193.88 94.17-3.12 59.13-3.94 92.663-.07 119.607 3.04 13.583 1.57 25.314 2.92 37.608 2.92 23.477.98 47.733 1.99 72.57.01 4.568-.41 9.002-.48 13.29-.55 6.144-.09 11.946-.18 18.013-1.22.268-.04.527.14.574.41.04.27-.14.53-.41.58-6.14 1.05-11.98 1.14-18.17 1.24-4.27.07-8.69.14-13.23.55-24.9 1.99-49.19.98-72.68 0-12.33 0-24.09-1.35-37.7-2.93-26.91-3.1-60.39-6.97-119.4-3.03-32.02 4-65.1 3.54-94.28 3.13-24.64-.34-45.92-.64-60.84 1.84-9.18.01-16.55 1.16-23.68 2.27-6.79 1.06-13.26 2.07-20.8 2.07zm481.432-11.092a.498.498 0 0 1-.094-.986c2.084-.403 4.146-.86 6.126-1.362a.49.49 0 0 1 .604.36.495.495 0 0 1-.36.603c-1.998.506-4.078.97-6.18 1.375a.454.454 0 0 1-.096.01zm-296.38-38.933c-40.594 0-96.002-8.693-103.455-17.372a.493.493 0 0 1-.09-.492c10.377-28.627 88.078-13.018 156.632.75 4.25.855 8.46 1.702 12.62 2.53.27.053.44.315.39.584a.505.505 0 0 1-.59.39c-4.16-.828-8.37-1.674-12.63-2.53-67.93-13.643-144.9-29.103-155.4-1.667 8.69 9.04 77.33 19.65 119.65 16.186 4.62-.377 9.91-1.73 15.51-3.16 7.17-1.834 14.6-3.725 20.76-3.492 3.1.123 7 .663 12.29 1.7a.497.497 0 1 1-.2.973c-5.23-1.025-9.09-1.56-12.14-1.68-6.02-.24-13.37 1.645-20.48 3.462-5.64 1.44-10.97 2.8-15.68 3.18-5.26.43-11.08.63-17.23.63zm298.498-4.033a.497.497 0 0 1-.037-.993c1.126-.08 2.25-.17 3.375-.27a.503.503 0 0 1 .083 1c-1.12.1-2.25.19-3.38.28h-.04zM406.062 193c-24.582 0-49.5-.96-74.424-3.475a.495.495 0 0 1-.445-.544c.027-.27.29-.47.544-.44 56.68 5.72 113.335 3.39 166.114.02.31-.03.52.19.53.47.02.28-.19.51-.46.53-29.62 1.9-60.46 3.46-91.85 3.46zm18.598 12.085c-52.205 0-99.96-5.164-144.616-15.57a.498.498 0 0 1 .225-.97C344.8 203.586 415.85 207.66 497.45 201c.29-.02.51.182.53.454a.498.498 0 0 1-.46.536c-25.26 2.062-49.52 3.097-72.88 3.097z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M397.32 198.88c-31.224 0-62.554-2.133-93.336-9.366a.496.496 0 0 1-.37-.597.493.493 0 0 1 .597-.37c53.1 12.476 107.93 9.736 160.95 7.086 12.82-.64 26.07-1.304 39.05-1.736h.02c.27 0 .49.212.5.48.01.275-.2.504-.48.514-12.97.44-26.22 1.1-39.03 1.74-22.39 1.12-45.11 2.26-67.88 2.26zm-196.073-12.11c-38.676.002-75.085-10.325-76.02-17.01-.255-1.818 1.795-3.125 6.095-3.882 22.618-4.048 41.025-.758 102.012 10.143 11.095 1.99 23.613 4.23 37.836 6.72.27.05.452.31.404.58a.51.51 0 0 1-.576.41c-14.225-2.49-26.743-4.73-37.84-6.71-60.85-10.87-79.217-14.16-101.663-10.14-3.57.63-5.446 1.61-5.284 2.77.92 6.53 49 19.93 95.03 15.16.47-.05.66-.39.69-.7.03-.31-.1-.68-.55-.81-67.3-19.31-72.69-11.27-72.72-11.18-.15.37.36.68.52.76 18.08 9.81 36.22 10.2 37.24 8.89-.04 0-.23-.26-1.12-.67-2.99-1.38-6.28-2.13-9.53-2.16a.5.5 0 0 1-.49-.5c.01-.27.23-.49.5-.49h.01c3.39.04 6.83.82 9.95 2.26 1.11.51 1.65 1.01 1.69 1.56.02.2-.03.59-.52.91-2.87 1.85-21.2.3-38.17-8.9-.88-.48-1.26-1.27-.96-2.01 1.45-3.52 18.64-5.26 73.92 10.61.84.24 1.35.987 1.28 1.86-.08.867-.71 1.51-1.57 1.6-6.65.687-13.41.996-20.1.996zm249.12-89.345h-.035c-13.187-.922-27.314-1.808-41.28-2.06a.498.498 0 0 1-.49-.505c.006-.275.246-.463.507-.488 13.98.25 28.13 1.14 41.33 2.06.27.02.48.257.46.53a.502.502 0 0 1-.5.463zm-364.905 7.03c-6.47 0-14.673-.62-25.698-2.05a.497.497 0 1 1 .13-.986c33.55 4.35 40.74 1.15 52.643-4.15 2.14-.95 4.354-1.94 6.92-2.97 16.56-6.67 35.168-3.98 63.333.1 22.488 3.25 50.474 7.29 88.308 8.27.275 0 .49.23.485.51s-.233.47-.51.48c-37.893-.98-65.912-5.03-88.425-8.29-28.004-4.05-46.505-6.73-62.82-.16-2.55 1.02-4.754 2-6.886 2.95-8.133 3.61-14.095 6.26-27.48 6.26z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M271.086 96.13h-.037c-18.4-1.332-37.03-3.493-55.05-5.582-14.61-1.694-29.72-3.446-44.8-4.776-38.12-2.38-51.7 1.274-63.68 4.497-6.14 1.65-11.94 3.21-20.42 3.88a.498.498 0 0 1-.54-.46c-.02-.28.18-.52.45-.54 8.38-.67 14.14-2.21 20.23-3.85 12.05-3.25 25.71-6.93 64-4.53 15.12 1.33 30.23 3.08 44.84 4.78 18.01 2.08 36.63 4.24 55 5.58a.495.495 0 0 1-.04.99zM419.33 68.81h-.013c-3.42-.08-6.84-.142-10.263-.183a.496.496 0 0 1 .006-.993h.006c3.426.04 6.85.102 10.275.182.28.006.5.234.49.51 0 .27-.23.484-.5.484zm14.368.424h-.017c-1.59-.056-3.19-.11-4.78-.16a.498.498 0 0 1-.48-.512.502.502 0 0 1 .52-.48c1.6.05 3.2.103 4.79.16.28.008.49.24.48.513a.5.5 0 0 1-.5.48zm-17.7 15.703h-.02c-2.312-.098-4.624-.19-6.936-.277a.497.497 0 1 1 .037-.993c2.31.086 4.62.18 6.94.277.27.012.48.243.47.517-.01.27-.23.48-.5.48zm-144.912 3.57c-.02 0-.042 0-.062-.004C197.7 79.38 143.42 76.18 114.058 79.24a.492.492 0 0 1-.546-.443.497.497 0 0 1 .443-.546c29.437-3.07 83.794.14 157.192 9.27a.5.5 0 0 1-.068 1zm170.11-8.11h-.024c-10.71-.495-21.422-.987-32.133-1.47a.503.503 0 0 1-.48-.52c.01-.275.2-.5.52-.475 10.71.485 21.42.978 32.13 1.47a.5.5 0 0 1 .47.52.51.51 0 0 1-.5.474zm-178.162-4.79c-16.91 0-33.73-1.66-51.407-3.404-34.257-3.38-69.68-6.876-108.904 1.867a.497.497 0 0 1-.216-.97c39.382-8.778 74.885-5.274 109.22-1.886 20.16 1.99 39.196 3.873 58.504 3.295.26-.01.51.2.52.48a.5.5 0 0 1-.48.51c-2.41.07-4.82.1-7.22.1zm146.026-21.57a.497.497 0 0 1-.017-.994c2.86-.095 5.894-.15 6.334-.15a.5.5 0 1 1 0 .998c-.436 0-3.452.06-6.3.15h-.017zM261.154 66.1c-32.786 0-65.883-2.412-97.988-4.752-13.766-1.004-28-2.04-41.954-2.868-.274-.016-.483-.25-.467-.526s.237-.482.526-.466c13.96.827 28.2 1.865 41.97 2.868 35.33 2.575 71.87 5.238 107.84 4.673.27-.02.5.21.51.48.01.27-.21.5-.49.5-3.3.05-6.62.07-9.93.07zm-5.338-5.477c-19.64 0-25.53-.83-46.154-3.737-2.693-.38-5.638-.794-8.897-1.247-1.536-.22-3.155-1.58-3.12-3.26.03-1.28 1.054-3.51 7.618-4.14 9.01-.86 17.846-4.88 27.2-9.13 11.057-5.03 23.587-10.72 38.577-12.03.28-.04.517.18.54.45a.49.49 0 0 1-.45.53c-14.82 1.3-27.27 6.96-38.254 11.95-9.433 4.29-18.344 8.34-27.52 9.21-4.17.4-6.68 1.58-6.715 3.16-.02 1.1 1.18 2.09 2.27 2.25 3.26.45 6.21.86 8.9 1.24 25.1 3.53 28.33 3.99 61.28 3.62.24-.02.5.21.51.49.01.27-.21.5-.49.5-5.96.06-10.95.1-15.27.1zm-91.97-9.13c-8.34 0-16.52-1.12-24.533-2.22-4.89-.67-9.947-1.36-14.91-1.774a.506.506 0 0 1-.453-.54.49.49 0 0 1 .537-.46c4.988.41 10.058 1.11 14.96 1.78 12.82 1.76 26.074 3.57 39.65.71 7.18-1.44 13.205-4.39 19.585-7.51 2.322-1.14 4.724-2.31 7.17-3.4.354-.15 45.7-15.66 65.197-17a.5.5 0 0 1 .53.46c.01.27-.19.51-.47.53-19.3 1.33-64.52 16.77-64.87 16.92-2.43 1.07-4.82 2.24-7.13 3.38-6.16 3.01-12.53 6.12-19.83 7.58-5.21 1.09-10.36 1.51-15.45 1.51z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M163.11 43.276c-5.81 0-11.127-.74-16.112-1.433-3.864-.537-7.514-1.044-10.986-1.14a.498.498 0 0 1-.484-.51.513.513 0 0 1 .51-.484c3.528.09 7.205.6 11.097 1.14 9.805 1.36 20.916 2.9 34.45-1.45 10.518-3.39 19.763-7.11 28.705-10.7 18.508-7.44 35.99-14.47 59.918-16.24.27-.02.513.18.533.46.02.27-.18.51-.45.53-23.77 1.76-41.18 8.76-59.62 16.16-8.96 3.6-18.22 7.32-28.77 10.72-6.83 2.2-13.04 2.92-18.78 2.92zm-31.138-2.933c-.015 0-.03 0-.044-.002-1.795-.15-3.59-.3-5.387-.44a.493.493 0 0 1-.45-.53c.02-.27.26-.48.54-.46 1.8.14 3.6.29 5.4.45.28.03.48.27.45.54-.02.26-.24.46-.49.46zm48.776-15.293c-3.185 0-6.386-.194-9.61-.622a.496.496 0 1 1 .133-.985c18.58 2.468 36.61-2.98 54.04-8.25 7.46-2.255 15.18-4.587 22.84-6.268 7.62-1.674 15.51-2.745 22.89-3.652.28-.04.52.16.56.432.04.272-.16.52-.43.554-7.36.9-15.21 1.97-22.79 3.63-7.62 1.67-15.31 4-22.76 6.25-14.52 4.39-29.46 8.9-44.84 8.9zm-19.566-2.333a.492.492 0 0 1-.1-.01c-1.09-.22-2.182-.452-3.27-.683-.27-.057-.48-.33-.424-.597s.276-.447.55-.392l.08.017c1.086.23 2.173.46 3.263.68.27.055.45.318.39.587-.05.23-.25.39-.48.39z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M163.23 37.528c-4.926 0-12.355-.683-22.627-1.75a.498.498 0 0 1 .103-.99c13.015 1.35 27.765 2.88 29.072.47.26-.49.26-.98 0-1.51-1.136-2.29-6.665-4.57-11.116-5.27a.5.5 0 0 1 .153-.99c3.922.61 10.402 2.87 11.853 5.8.405.81.4 1.65-.015 2.42-.686 1.26-3.083 1.79-7.423 1.79zm37.99-24.104c-.7 0-1.41-.017-2.13-.052a.5.5 0 0 1-.474-.52.495.495 0 0 1 .52-.473c8.85.43 16.007-1.99 23.587-4.55 8.56-2.89 18.265-6.18 31.982-5.73.274.01.49.24.48.51-.007.27-.244.51-.512.48-13.533-.43-22.738 2.67-31.632 5.67-7.05 2.38-13.75 4.64-21.82 4.64zm69.134 43.714c-15.742 0-29.134-1.434-40.923-4.38-1.53-.382-2.59-1.592-2.76-3.157-.18-1.57.62-3.05 2.03-3.77 11.68-5.96 25.52-10.29 42.3-13.23.27-.04.53.14.58.41.05.27-.13.53-.4.58-16.68 2.93-30.43 7.22-42.02 13.15-1.26.65-1.6 1.86-1.49 2.78.11.9.69 1.97 2.03 2.31 11.89 2.97 25.44 4.39 41.41 4.35.28 0 .5.22.5.5.01.28-.22.5-.49.5l-.73.01z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M271.085 52.007h-.013c-13.993-.368-19.25-3.655-19.498-6.358-.134-1.46 1.108-2.68 3.164-3.12 5.33-1.16 10.8-2.22 16.263-3.15.27-.05.53.13.58.4.05.27-.13.53-.4.57-5.44.92-10.9 1.98-16.22 3.13-1.53.32-2.47 1.13-2.38 2.05.16 1.72 4.24 5.08 18.54 5.45.28 0 .49.23.49.51 0 .27-.22.48-.49.48z"
                                ></path>
                                <g
                                    fill="#C3CCD4"
                                    opacity=".2"
                                >
                                    <path
                                        fill-rule="evenodd"
                                        d="M271.085 189.878h137.98v1.705h-137.98z"
                                        clip-rule="evenodd"
                                    ></path>
                                    <path
                                        d="M409.064 193.074h-137.98a1.49 1.49 0 0 1-1.49-1.49v-1.706c0-.823.667-1.49 1.49-1.49h137.98a1.49 1.49 0 0 1 1.492 1.49v1.705a1.49 1.49 0 0 1-1.492 1.49z"
                                    ></path>
                                </g>
                                <path
                                    fill="#D3DCE6"
                                    d="M332.412 135.368L303.78 86.37l64.398-33.76 16.557 29.138-.26.267-52.063 53.353zm-27.248-48.6l27.45 46.97 50.89-52.15-15.715-27.65-62.63 32.83z"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M381.624 83.723v-.005l-.82-6.958.987-.115.83 7.015m-3.55 2.748l-1.88-16.014 1-.064 1.88 15.962m-5.51-22.39l2.93 25.014-.99.116-2.93-25.013zm-.6 27.7V91.6l-3.99-33.944.99-.116 3.99 34.002m-7.33-37.86l4.76 40.5-.99.115-4.75-40.5zm-2.69 1.418l4.9 41.71-.99.116-4.89-41.71zm-2.73 1.414l5.04 42.915-.99.11-5.03-42.92zm-2.68 1.418l5.18 44.127-.99.11-5.18-44.13zm1.62 46.864l-5.33-45.402.01-.07.5.08.48-.056 5.32 45.333m-8.04-43.91l5.46 46.55-.99.12-5.46-46.54zm-2.69 1.43l5.6 47.76-.99.12-5.6-47.75zm2.05 50.5l-5.74-48.96.99-.06 5.74 48.91M346 65.05l5.89 50.18-.99.12-5.9-50.17zm-2.72 1.42l6.03 51.38-.99.12-6.02-51.38zm2.49 54.07v-.002L339.58 68l.99-.116 6.18 52.587m-8.89-51.17l6.318 53.8-.99.12-6.317-53.8zm-2.72 1.41l6.45 55.01-.986.12-6.454-55.01zm-2.696 1.43l6.593 56.22-.99.12-6.593-56.22zm-2.693 1.42l6.74 57.43-.99.12-6.73-57.42zm-2.7 1.43l6.88 58.63-.99.12-6.88-58.63zm-2.71 1.41l6.35 54.13-.99.12-6.35-54.13zm-2.71 1.42l5.46 46.56-.99.12-5.46-46.56zm-2.7 1.41l4.57 38.99-.99.12-4.57-38.99zm-2.7 1.42l3.68 31.42-.99.12-3.68-31.42zm-.89 25.39l-2.8-23.85.99-.07 2.79 23.8m-5.52-22.44l1.91 16.29-.99.12-1.91-16.28zm-2.66 10.26L307.1 85l.99-.064 1.02 8.67m-3.74-7.306l.133 1.16-.988.114-.134-1.16z"
                                ></path>
                                <path
                                    fill="#F7F8FC"
                                    fill-rule="evenodd"
                                    d="M367.52 157.73l20.763-34.766-60.21-58.105-19.61 60.77"
                                    clip-rule="evenodd"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M367.702 158.394l-.42-.228-59.42-32.295.127-.39 19.85-61.53 61.06 58.94-21.21 35.52zm-58.64-33.003l58.275 31.68 20.316-34.01L328.3 65.77l-19.237 59.62z"
                                ></path>
                                <path
                                    fill="#F7F8FC"
                                    d="M325.16 159.938c-14.295 0-25.925-11.622-25.925-25.908s11.63-25.91 25.925-25.91 25.925 11.624 25.925 25.91-11.63 25.908-25.925 25.908zm0-50.823c-13.746 0-24.93 11.176-24.93 24.915 0 13.737 11.184 24.914 24.93 24.914s24.93-11.177 24.93-24.914c0-13.74-11.184-24.915-24.93-24.915z"
                                ></path>
                                <path
                                    fill="#F7F8FC"
                                    fill-rule="evenodd"
                                    d="M350.588 134.03c0-14.034-11.384-25.41-25.428-25.41a25.32 25.32 0 0 0-12.214 3.12l-4.483 13.892 38.742 21.057a25.286 25.286 0 0 0 3.383-12.66z"
                                    clip-rule="evenodd"
                                ></path>
                                <path
                                    fill="#D3DCE6"
                                    d="M347.393 147.355l-.426-.23-39.104-21.255 4.67-14.472.174-.095a25.96 25.96 0 0 1 12.453-3.182c14.295 0 25.925 11.63 25.925 25.91 0 4.53-1.193 8.99-3.45 12.91l-.242.42zm-38.33-21.964l37.948 20.63c2.02-3.66 3.08-7.79 3.08-11.98 0-13.73-11.18-24.91-24.93-24.91-4.12 0-8.19 1.03-11.8 2.97l-4.29 13.31z"
                                ></path>
                                <circle
                                    cx="337.135"
                                    cy="156.534"
                                    r="2.909"
                                    fill="#F7F8FC"
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                ></circle>
                                <path
                                    fill="#D3DCE6"
                                    d="M337.135 159.938c-1.878 0-3.405-1.527-3.405-3.403s1.528-3.403 3.405-3.403a3.402 3.402 0 1 1 .006 6.806zm0-5.813a2.41 2.41 0 0 0 0 4.818c1.33 0 2.412-1.08 2.412-2.41s-1.083-2.408-2.412-2.408z"
                                ></path>
                                <circle
                                    cx="302.42"
                                    cy="145.656"
                                    r="2.909"
                                    fill="#F7F8FC"
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                ></circle>
                                <path
                                    fill="#D3DCE6"
                                    d="M302.42 149.06a3.408 3.408 0 0 1-3.405-3.404c0-1.876 1.528-3.403 3.405-3.403s3.405 1.527 3.405 3.403a3.41 3.41 0 0 1-3.405 3.404zm0-5.814c-1.33 0-2.41 1.08-2.41 2.41 0 1.328 1.08 2.41 2.41 2.41s2.41-1.082 2.41-2.41c0-1.33-1.08-2.41-2.41-2.41z"
                                ></path>
                                <g fill="#C4E7EC">
                                    <path
                                        d="M62.667 221.805c0 16.28 13.206 29.478 29.496 29.478s29.496-13.198 29.496-29.478v-3.43h-59v3.43z"
                                    ></path>
                                    <path
                                        d="M92.164 252.774c-17.087 0-30.988-13.893-30.988-30.968v-3.43c0-.823.668-1.49 1.492-1.49h58.993c.83 0 1.5.667 1.5 1.49v3.43c0 17.075-13.9 30.968-30.99 30.968zM64.16 219.867v1.938c0 15.43 12.562 27.986 28.003 27.986s28.005-12.55 28.005-27.98v-1.94h-56.01z"
                                    ></path>
                                </g>
                                <g fill="#4FB1C3">
                                    <path d="M119.827 193.78s-4.865 11.86-20.89 14.46c0 0 4.958-15.62 20.89-14.46z"></path>
                                    <path
                                        d="M97.5 209.48l.49-1.54c.052-.164 5.394-16.37 21.91-15.152l1.368.1-.52 1.268c-.208.506-5.265 12.407-21.65 15.065l-1.597.26zm20.692-14.768c-10.877 0-15.97 8.56-17.648 12.21 10.887-2.368 15.976-9.298 17.678-12.21h-.03z"
                                    ></path>
                                </g>
                                <g fill="#4FB1C3">
                                    <path d="M74.347 119.41s10.01 17.7 15.55 81.314c0 0-25.237-35.12-15.55-81.315z"></path>
                                    <path
                                        d="M91.2 204.244l-2.112-2.94c-.255-.354-25.38-36.006-15.715-82.098l.54-2.58 1.3 2.294c.412.73 10.18 18.612 15.673 81.718l.315 3.606zM74.73 122.67c-6.355 35.686 8.124 64.474 13.81 74.06-2.815-30.276-6.638-49.31-9.405-60.076-1.792-6.97-3.374-11.432-4.405-13.985z"
                                    ></path>
                                </g>
                                <g fill="#4FB1C3">
                                    <path d="M65.35 182.087s13.12 2.888 20.058 29.834c0 0-17.374-5.07-20.058-29.83z"></path>
                                    <path
                                        d="M86.806 213.364l-1.677-.49c-.18-.05-18.05-5.548-20.77-30.68l-.15-1.375 1.35.29c.56.12 13.8 3.33 20.8 30.55l.43 1.69zm-20.268-29.77c2.526 18.175 13.146 24.756 17.4 26.69-3.466-12.36-8.243-19.06-11.72-22.538-2.334-2.336-4.39-3.55-5.68-4.152z"
                                    ></path>
                                </g>
                                <g fill="#4FB1C3">
                                    <path d="M124.924 151.522s.098 28.39-24.684 49.42c0 0 7.43-32.85 24.684-49.42z"></path>
                                    <path
                                        d="M98.613 203.627l.657-2.904c.306-1.353 7.694-33.332 24.965-49.917l1.676-1.61.01 2.323c0 .28-.18 29.09-25.03 50.18l-2.27 1.92zm25.163-49.52c-12.582 13.488-19.533 35.763-21.763 43.93 17.712-16.488 21.11-36.837 21.763-43.93z"
                                    ></path>
                                </g>
                                <g fill="#4FB1C3">
                                    <path d="M103.822 128.982s6.263 43.636-12.36 69.548c0 0 .023-45.884 12.36-69.548z">
                                    </path>
                                    <path
                                        d="M90.467 201.62v-3.09c0-.117.024-11.69 1.56-26.006 2.067-19.272 5.74-34.077 10.913-44l1.428-2.74.44 3.058c.062.44 6.104 44.332-12.537 70.267l-1.8 2.51zm12.746-69.076c-8.844 19.925-10.416 52.19-10.695 62.62 13.18-21.174 11.64-52.343 10.695-62.62z"
                                    ></path>
                                </g>
                                <path
                                    fill="#5F5371"
                                    d="M124.5 218.446H59.827a1.492 1.492 0 1 1 0-2.982h64.67a1.492 1.492 0 0 1 .003 2.982z"
                                ></path>
                                <path
                                    fill="#D6696F"
                                    d="M122.76 227.117a28.1 28.1 0 0 1-2.185 6.68H63.753a28.085 28.085 0 0 1-2.185-6.68h61.192z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M123.102 228.11H61.225a.993.993 0 1 1 0-1.987h61.877a.994.994 0 1 1 0 1.988zm-1.86 6.682H63.086a.994.994 0 1 1 .005-1.988h58.16c.55 0 1 .445 1 .994a.99.99 0 0 1-.99.994zM97.386 216.35a.993.993 0 0 1-.988-1.12c.06-.462 6.2-46.37 30.652-67.168a.995.995 0 0 1 1.29 1.515c-12.45 10.587-19.94 27.928-24.02 40.61-4.45 13.79-5.94 25.18-5.95 25.295-.07.5-.49.867-.99.867zm-5.924.997a.996.996 0 0 1-.992-.93c-.052-.805-5.437-80.812-19.64-102.784a.994.994 0 0 1 .297-1.374.993.993 0 0 1 1.375.29c6.098 9.43 11.308 29.77 15.49 60.45 3.103 22.78 4.45 43.08 4.464 43.28a.99.99 0 0 1-.928 1.05h-.066z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M98.233 211.198a.993.993 0 0 1-.958-1.264c.058-.205 5.99-20.37 25.017-17.045.54.09.903.61.808 1.15a.993.993 0 0 1-1.152.8c-7.233-1.28-13.253.95-17.888 6.61-3.505 4.28-4.858 8.97-4.87 9.01a.99.99 0 0 1-.957.72zm-7.363-1.965h-.006a.994.994 0 0 1-.987-1c0-.16.137-16.156 2.076-34.446 2.614-24.664 7.09-41.546 13.302-50.18a.995.995 0 1 1 1.616 1.162c-14.38 19.98-15 82.84-15 83.47 0 .54-.45.98-.99.98zm-4.847 7.393a.997.997 0 0 1-.99-.894c-.025-.26-2.847-25.993-22.788-35.395a.994.994 0 0 1 .85-1.798c20.97 9.88 23.892 36.72 23.92 36.99.054.54-.345 1.03-.89 1.09h-.1zm314.472 36.148h-45.24a1.49 1.49 0 0 1 0-2.982h45.24a1.492 1.492 0 1 1 0 2.982z"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M377.958 251.405a.994.994 0 0 1-.995-.994v-85.46c0-.55.445-.99.995-.99s.995.45.995 1v85.47c0 .55-.445 1-.995 1zm21.652-75.412a.994.994 0 0 1-.995-.994v-10.06c0-.55.445-1 .995-1s.995.44.995.99V175c0 .55-.445.993-.995.993z"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M401.69 178.306a2.08 2.08 0 0 1-4.16 0c0-1.147 2.08-4.692 2.08-4.692s2.08 3.545 2.08 4.692z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M399.61 181.378a3.075 3.075 0 0 1-3.073-3.07c0-1.316 1.696-4.31 2.216-5.196.355-.608 1.36-.61 1.715 0 .52.886 2.217 3.88 2.217 5.195 0 1.693-1.38 3.07-3.075 3.07zm0-5.7c-.627 1.22-1.08 2.293-1.084 2.63a1.085 1.085 0 0 0 2.17 0c-.005-.338-.457-1.41-1.086-2.63zm-10.992 76.224H367.13c-2.046 0-3.61-2.036-4.426-3.97-12.453-7.435-18.99-20.008-16.708-32.188.217-1.153.498-2.32.837-3.467 1.523-5.15 4.387-10.12 8.51-14.767l.18-.2c.62-.698 1.24-1.395 1.832-2.116l11.837-14.404a1.492 1.492 0 0 1 1.153-.545h15.06c.446 0 .868.2 1.152.545l11.83 14.39c.58.704 1.185 1.384 1.79 2.066l.224.253c4.13 4.64 7 9.61 8.52 14.77.34 1.15.63 2.32.84 3.47 2.29 12.19-4.26 24.78-16.71 32.19-.82 1.93-2.38 3.97-4.42 3.97zm-17.57-68.675l-11.388 13.86a79.875 79.875 0 0 1-1.908 2.204l-.177.2c-3.832 4.32-6.484 8.91-7.88 13.64-.31 1.05-.57 2.12-.766 3.18-2.08 11.08 4.09 22.58 15.7 29.32.3.18.55.47.67.8.53 1.48 1.5 2.52 1.82 2.52h21.48c.32 0 1.29-1.03 1.82-2.51.12-.33.35-.61.66-.79 11.63-6.73 17.8-18.24 15.73-29.32-.2-1.05-.46-2.12-.77-3.17-1.4-4.73-4.06-9.32-7.89-13.63l-.23-.25c-.63-.71-1.26-1.42-1.87-2.15l-11.37-13.86h-13.65z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M388.375 182.355h-21.002a1.492 1.492 0 1 1 .008-2.982h21c.83 0 1.49.668 1.49 1.49 0 .824-.67 1.492-1.49 1.492zm-4.098-4.68h-12.8a2.746 2.746 0 0 1-2.744-2.74v-2.05a2.746 2.746 0 0 1 2.744-2.743h12.8a2.746 2.746 0 0 1 2.744 2.742v2.05a2.745 2.745 0 0 1-2.74 2.742zm-12.56-2.98h12.32v-1.57h-12.32v1.57z"
                                ></path>
                                <g fill="#FBB563">
                                    <path d="M374.826 100.966h6.102v66.15h-6.102z"></path>
                                    <path
                                        d="M380.928 168.607h-6.102a1.492 1.492 0 0 1-1.492-1.49v-66.15c0-.825.668-1.492 1.492-1.492h6.102a1.49 1.49 0 0 1 1.492 1.49v66.15c0 .824-.67 1.492-1.492 1.492zm-4.61-2.982h3.118v-63.168h-3.118v63.168z"
                                    ></path>
                                </g>
                                <path
                                    fill="#FFF"
                                    d="M387.098 247.405h-18.445c-1.738 0-3-1.946-3.57-3.32-10.64-6.306-16.235-17.014-14.29-27.38.18-.972.42-1.964.71-2.95 1.566-5.294 4.622-10.696 8.174-14.45l11.987-14.23a.99.99 0 0 1 .76-.354h10.902a.98.98 0 0 1 .76.36l12.022 14.26c3.52 3.72 6.577 9.12 8.143 14.42.29.98.53 1.97.72 2.96 1.95 10.38-3.66 21.09-14.29 27.39-.57 1.38-1.83 3.32-3.57 3.32zm-14.212-60.695l-11.727 13.92c-3.39 3.58-6.27 8.68-7.75 13.69-.27.92-.5 1.846-.67 2.75-1.81 9.628 3.54 19.625 13.62 25.466.2.118.37.313.45.534.47 1.322 1.37 2.347 1.83 2.347h18.44c.47 0 1.35-1.004 1.83-2.347a1 1 0 0 1 .43-.525c10.09-5.84 15.44-15.84 13.64-25.475-.18-.92-.4-1.846-.67-2.755-1.48-5.01-4.37-10.114-7.72-13.655l-11.76-13.95h-9.98z"
                                ></path>
                                <g fill="#D6696F">
                                    <path d="M431.515 164.944H324.4l8.287-61.806h90.542"></path>
                                    <path
                                        d="M431.515 166.435H324.402c-.43 0-.84-.185-1.123-.51a1.458 1.458 0 0 1-.36-1.18l8.28-61.804c.1-.74.73-1.29 1.47-1.29h90.54c.74 0 1.37.56 1.47 1.3l8.28 61.81c.05.43-.08.86-.36 1.18-.28.33-.69.51-1.12.51zm-105.408-2.982H429.81l-7.886-58.823h-87.93l-7.887 58.823z"
                                    ></path>
                                </g>
                                <path
                                    fill="#D6696F"
                                    d="M331.343 162.12l6.69-56.16"
                                ></path>
                                <path
                                    fill="#E68887"
                                    d="M331.345 163.115a.994.994 0 0 1-.988-1.112l6.69-56.16a.997.997 0 0 1 1.104-.87c.55.066.94.56.87 1.106l-6.68 56.15c-.06.5-.49.87-.98.87z"
                                ></path>
                                <path
                                    fill="#D6696F"
                                    d="M343.013 118.78l1.13-12.322"
                                ></path>
                                <path
                                    fill="#E68887"
                                    d="M343.014 119.775a.994.994 0 0 1-.992-1.085l1.132-12.322a.995.995 0 1 1 1.982.18l-1.132 12.323a.998.998 0 0 1-.99.91z"
                                ></path>
                                <path
                                    fill="#D6696F"
                                    d="M339.084 161.624l3.454-37.657"
                                ></path>
                                <path
                                    fill="#E68887"
                                    d="M339.084 162.618c-.03 0-.06 0-.09-.004a.992.992 0 0 1-.9-1.08l3.453-37.657a.995.995 0 0 1 1.98.18l-3.453 37.657a.995.995 0 0 1-.99.904z"
                                ></path>
                                <path
                                    fill="#D6696F"
                                    d="M347.646 142.74l2.334-36.282"
                                ></path>
                                <path
                                    fill="#E68887"
                                    d="M347.646 143.734c-.02 0-.043 0-.065-.002a.99.99 0 0 1-.92-1.056l2.34-36.28a.99.99 0 0 1 1.06-.93c.55.036.97.51.93 1.057l-2.33 36.282a.99.99 0 0 1-.99.93z"
                                ></path>
                                <path
                                    fill="#D6696F"
                                    d="M346.43 161.624l.794-12.323"
                                ></path>
                                <path
                                    fill="#E68887"
                                    d="M346.43 162.618c-.02 0-.042 0-.064-.002a.996.996 0 0 1-.93-1.056l.795-12.323a1 1 0 0 1 1.06-.928c.55.03.97.5.93 1.05l-.79 12.32c-.03.52-.47.93-.99.93z"
                                ></path>
                                <path
                                    fill="#4FB1C3"
                                    d="M170.353 221.345l-14.08 9.206a4.135 4.135 0 0 1-5.732-1.19l-10-15.29 21.01-13.74 10.01 15.29c1.25 1.92.72 4.48-1.2 5.73z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M154.014 232.22a5.14 5.14 0 0 1-4.305-2.32l-10.01-15.29a.943.943 0 0 1-.14-.747c.05-.258.2-.484.42-.63l21.01-13.736c.46-.3 1.07-.172 1.38.287l10.01 15.288a5.105 5.105 0 0 1 .73 3.86 5.094 5.094 0 0 1-2.22 3.246l-14.08 9.206a5.13 5.13 0 0 1-2.81.835zm-12.106-17.867l9.465 14.457a3.152 3.152 0 0 0 4.356.91l14.08-9.206a3.12 3.12 0 0 0 1.35-1.988c.17-.822.01-1.662-.45-2.365l-9.47-14.45-19.35 12.65z"
                                ></path>
                                <path
                                    fill="#C4E7EC"
                                    d="M153.14 225.673a.992.992 0 0 1-.833-.45l-5.82-8.89a.996.996 0 0 1 1.664-1.09l5.83 8.892c.3.46.17 1.076-.29 1.376-.17.11-.35.17-.54.17z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M162.695 199.574L139.38 214.82"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M139.38 216.31a1.49 1.49 0 0 1-.818-2.738l23.317-15.246a1.486 1.486 0 0 1 2.06.43c.45.69.26 1.614-.43 2.065l-23.32 15.25c-.26.17-.54.25-.82.25zm30.366-2.457a1.006 1.006 0 0 1-.833-.45l-6.208-9.484a1 1 0 0 1 .288-1.38l4.57-2.99c.798-.52 1.752-.7 2.686-.51.93.19 1.73.74 2.25 1.54l3.39 5.17a3.58 3.58 0 0 1-1.04 4.94l-4.57 2.99c-.17.1-.36.16-.55.16zm-4.833-10.192l5.12 7.83 3.738-2.44c.73-.47.94-1.46.46-2.19l-3.39-5.17c-.23-.35-.58-.59-1-.68a1.53 1.53 0 0 0-1.19.23l-3.73 2.45zm311.137 49.12h-23.786c-.824 0-1.492-.66-1.492-1.49s.668-1.49 1.492-1.49h23.787c.83 0 1.5.67 1.5 1.49s-.67 1.49-1.49 1.49z"
                                ></path>
                                <path
                                    fill="#E6E7F1"
                                    d="M464.158 251.283c-9.992 0-18.092-8.095-18.092-18.08v-9.823h36.184v9.822c0 9.986-8.1 18.08-18.092 18.08z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M464.158 252.774c-10.798 0-19.584-8.78-19.584-19.572v-9.822c0-.823.668-1.49 1.492-1.49h36.184a1.49 1.49 0 0 1 1.492 1.49v9.822c0 10.792-8.786 19.572-19.584 19.572zm-16.6-27.903v8.34c0 9.15 7.447 16.59 16.6 16.59 9.153 0 16.6-7.44 16.6-16.59v-8.33h-33.2z"
                                ></path>
                                <path
                                    fill="#4FB1C3"
                                    d="M481.592 189.17a3.147 3.147 0 0 1 3.146 3.145v13.713a6.29 6.29 0 0 1-6.292 6.288v-20a3.145 3.145 0 0 1 3.146-3.145z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M478.446 213.808a1.492 1.492 0 0 1-1.492-1.49v-20.002a4.64 4.64 0 0 1 4.638-4.635 4.643 4.643 0 0 1 4.637 4.64v13.72c0 4.29-3.5 7.78-7.79 7.78zm3.146-23.146c-.912 0-1.654.742-1.654 1.653v18.274a4.812 4.812 0 0 0 3.307-4.56v-13.72c0-.92-.742-1.66-1.653-1.66z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M477.976 213.808h-7.184a1.492 1.492 0 1 1 0-2.982h7.184a1.492 1.492 0 1 1 0 2.982z"
                                ></path>
                                <path
                                    fill="#4FB1C3"
                                    d="M449.147 181.664a3.146 3.146 0 0 0-3.146 3.144v6.956c0 3.473 2.82 6.288 6.3 6.288v-13.244a3.144 3.144 0 0 0-3.14-3.144z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M452.293 199.542c-4.292 0-7.784-3.49-7.784-7.778v-6.957c0-2.555 2.08-4.634 4.63-4.634s4.64 2.08 4.64 4.634v13.244c0 .83-.67 1.5-1.49 1.5zm-3.146-16.387c-.912 0-1.654.742-1.654 1.652v6.957c0 2.125 1.39 3.93 3.308 4.56v-11.517c0-.91-.74-1.652-1.65-1.652z"
                                ></path>
                                <path
                                    fill="#A0BF82"
                                    d="M452.762 198.052h4.93"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M457.692 199.542h-4.93a1.492 1.492 0 1 1 0-2.982h4.93a1.492 1.492 0 1 1 0 2.982zm27.618 25.012h-42.305a1.492 1.492 0 1 1 0-2.982h42.305a1.492 1.492 0 1 1 0 2.982z"
                                ></path>
                                <path
                                    fill="#B9BAD5"
                                    d="M482.248 230.668v2.53c0 9.993-8.093 18.082-18.092 18.082-9.987 0-18.092-8.09-18.092-18.08v-2.544l8.556 7.592 9.537-8.017 9.632 8.02 8.45-7.58z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M473.788 239.242a.993.993 0 0 1-.636-.23l-8.993-7.486-8.9 7.483a1 1 0 0 1-1.3-.02l-8.56-7.59c-.41-.37-.45-1-.09-1.41.36-.41.99-.45 1.4-.09l7.91 7.02 8.88-7.47c.36-.31.9-.31 1.27-.01l8.97 7.47 7.82-7.01a.994.994 0 0 1 1.4.07c.36.41.33 1.04-.08 1.4l-8.46 7.58a.99.99 0 0 1-.66.25z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M464.158 252.774c-10.798 0-19.584-8.78-19.584-19.572v-9.822c0-.823.668-1.49 1.492-1.49h36.184a1.49 1.49 0 0 1 1.492 1.49v9.822c0 10.792-8.786 19.572-19.584 19.572zm-16.6-27.903v8.34c0 9.15 7.447 16.59 16.6 16.59 9.153 0 16.6-7.44 16.6-16.59v-8.33h-33.2z"
                                ></path>
                                <path
                                    fill="#4FB1C3"
                                    d="M464.443 169.036a6.348 6.348 0 0 0-6.35 6.345v47.37h12.7v-47.37c0-3.5-2.843-6.34-6.35-6.34z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M470.792 223.744h-12.697a.994.994 0 0 1-.995-.994v-47.368c0-4.047 3.294-7.34 7.343-7.34 4.05 0 7.343 3.294 7.343 7.34v47.368c0 .55-.445.994-.994.994zm-11.703-1.988h10.7v-46.374c0-2.95-2.4-5.35-5.36-5.35s-5.36 2.4-5.36 5.35v46.374z"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M255.954 199.283c-3.443-2.414-8.12.39-7.607 4.562l.6 8.887h6.065l4.377-11.69-2.4-1.32"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M255.012 214.224h-6.063c-.79 0-1.44-.608-1.49-1.39l-.6-8.888c-.31-2.442.86-4.822 3.04-6.13 2.18-1.31 4.83-1.213 6.91.247.07.05.14.108.2.17.23.003.47.062.7.185l2.39 1.32c.64.356.93 1.134.67 1.827l-4.38 11.69a1.5 1.5 0 0 1-1.4.97zm-4.67-2.982h3.636l3.563-9.515-1.26-.698a1.46 1.46 0 0 1-.34-.26c-.29-.01-.58-.09-.83-.27-1.12-.79-2.49-.84-3.66-.13-1.17.7-1.77 1.93-1.6 3.29l.51 7.58z"
                                ></path>
                                <path
                                    fill="#4FB1C3"
                                    d="M328.065 237.005c-.1.084-.2.16-.298.244-.275.21-.558.42-.848.62-13.69 9.9-37.26 7.95-59.07 6.38l-16.56-1.51-35.77-3.26v-33.47c0-.06 0-.11.01-.16 0-.06.01-.1.01-.15 0-.03 0-.05.01-.07.23-1.68 2.12-.89 3.32.7 1.86 2.5 4.15 4.59 6.76 6.14 3.17 1.88 6.82 2.95 10.8 2.95 6.28 0 11.89-3.44 15.93-8.22 1.52-1.8 2.82-3.77 3.85-5.84.04-.1.1-.21.15-.31.1-.2.19-.39.27-.59.12-.26.24-.51.34-.77l8.8 4.85 23.35 12.85 33.34 13.62c2.29.85 4.12 2.62 5.14 4.91l.43 1.04z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M293.666 247.046c-7.908 0-16.212-.598-24.414-1.19l-1.505-.108-52.36-4.768a1.49 1.49 0 0 1-1.355-1.485v-33.478c0-.093.003-.186.012-.28 0-.03.003-.057.004-.073 0-.097.012-.2.033-.3.18-1.06.83-1.833 1.75-2.072 1.61-.418 3.29.902 4.24 2.156 1.78 2.384 3.91 4.32 6.34 5.756 3.07 1.817 6.45 2.74 10.04 2.74 5.35 0 10.61-2.732 14.8-7.69a27.694 27.694 0 0 0 3.66-5.54c.04-.088.11-.222.18-.347.07-.128.15-.292.22-.463.14-.293.25-.518.34-.75a1.5 1.5 0 0 1 .89-.838c.4-.142.85-.106 1.22.1l32.07 17.664 33.26 13.593c2.63.97 4.75 2.996 5.95 5.688l.45 1.07c.25.6.09 1.3-.41 1.72l-.29.24c-.34.27-.64.49-.95.71-8.66 6.27-20.82 7.96-34.12 7.96zm-76.65-8.912l52.45 4.75c21.457 1.544 43.645 3.145 56.578-6.215l.2-.15c-.854-1.92-2.376-3.37-4.276-4.07l-33.384-13.65c-.053-.03-.105-.05-.155-.08l-30.75-16.93c-.05.08-.08.14-.11.2a31.237 31.237 0 0 1-4.07 6.17c-4.77 5.64-10.84 8.74-17.08 8.74-4.14 0-8.03-1.06-11.56-3.16-2.77-1.64-5.19-3.84-7.2-6.53-.23-.31-.47-.54-.67-.7v31.59z"
                                ></path>
                                <path
                                    fill="#857B98"
                                    d="M249.2 242.224c0-6.237-2.716-14.247-5.978-18.82 0 0-19.222 2.534-26.222-9.587v25.87l32.2 2.537z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M248.7 243.217c-.026 0-.05 0-.077-.003l-32.2-2.537c-.52-.04-.422-.472-.422-.99v-25.87c0-.45-.19-.845.25-.96.44-.12.65.076.87.465 6.56 11.41 25.17 9.12 25.36 9.096.37-.048.67.11.88.41 3.11 4.357 6.38 12.638 6.38 19.397 0 .277-.13.542-.33.73-.18.168-.44.262-.69.262zm-30.7-4.45l30.178 2.38c-.306-5.887-3.272-12.725-5.936-16.693-1.506.143-5.216.404-9.917-.316-6.437-.987-11.325-3.46-14.325-7.212v21.84z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M300.054 221.89l-.268.266a25.956 25.956 0 0 1-17.403-1.963l-20.52-10.067-2.622 3.002c-5.32 6.087-12.86 9.96-20.94 10.288-.43.023-.88.03-1.32.03-8.44 0-16.86-3.276-21.44-8.706v-8.723c0-.053 0-.107.01-.16 0-.053.01-.1.01-.145 0-.023 0-.046.01-.07.24-1.68 2.13-.885 3.33.704 1.87 2.498 4.15 4.59 6.76 6.14 3.18 1.88 6.83 2.95 10.8 2.95 6.28 0 11.89-3.438 15.94-8.22a29.364 29.364 0 0 0 3.85-5.834c.05-.1.1-.206.16-.306.1-.2.19-.39.28-.588.12-.252.24-.504.35-.764l8.81 4.85 23.35 12.855 10.91 4.46z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M236.97 224.938c-9.12 0-17.776-3.54-22.586-9.236l-.352-.417v-9.267c0-.09.003-.18.01-.272l.054-.473c.194-1.012.832-1.747 1.73-1.98 1.61-.418 3.288.902 4.235 2.156 1.78 2.38 3.91 4.31 6.34 5.75 3.07 1.81 6.45 2.74 10.04 2.74 5.35 0 10.6-2.73 14.8-7.69 1.44-1.7 2.67-3.56 3.66-5.54.04-.09.11-.22.18-.35.07-.13.15-.29.22-.47.14-.3.24-.52.34-.75l.64-1.54 33.54 18.47 12.9 5.27-2.15 2.15-.41.1c-6.17 1.45-12.71.72-18.4-2.08l-19.49-9.56-1.87 2.14c-5.71 6.52-13.73 10.46-22.01 10.79-.44.02-.91.03-1.38.03zm-19.954-10.757c4.278 4.74 12.035 7.78 19.954 7.78.417 0 .835 0 1.246-.03 7.48-.3 14.73-3.87 19.902-9.78l3.373-3.86 21.55 10.57c3.66 1.8 7.7 2.64 11.74 2.49l-6.34-2.6-30.75-16.93-.1.2c-1.12 2.24-2.48 4.3-4.07 6.18-4.77 5.64-10.83 8.75-17.07 8.75-4.13 0-8.02-1.06-11.56-3.15-2.76-1.64-5.19-3.83-7.2-6.53-.23-.3-.46-.53-.66-.69l.01 7.64z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M236.972 224.937c-9.12 0-17.774-3.537-22.588-9.23a1.49 1.49 0 0 1 .177-2.102 1.5 1.5 0 0 1 2.11.177c4.2 4.965 12.17 8.173 20.31 8.173.43 0 .85-.01 1.26-.025 7.47-.306 14.72-3.872 19.89-9.787l2.63-3c.45-.51 1.18-.656 1.78-.358l20.52 10.07a24.53 24.53 0 0 0 16.41 1.854c.81-.2 1.61.3 1.8 1.11.19.8-.31 1.6-1.11 1.79-6.17 1.45-12.71.71-18.4-2.08l-19.49-9.57-1.87 2.14c-5.71 6.52-13.73 10.46-22.01 10.8-.46.01-.92.02-1.38.02z"
                                ></path>
                                <circle
                                    cx="263.578"
                                    cy="218.66"
                                    r="2.68"
                                    fill="#857B98"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M263.578 222.333c-2.026 0-3.675-1.647-3.675-3.672a3.675 3.675 0 0 1 7.35 0c0 2.02-1.648 3.68-3.675 3.68zm0-5.357c-.93 0-1.685.755-1.685 1.684a1.686 1.686 0 0 0 3.37 0c0-.93-.755-1.684-1.685-1.684z"
                                ></path>
                                <circle
                                    cx="278.864"
                                    cy="224.77"
                                    r="2.68"
                                    fill="#857B98"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M278.864 228.442c-2.026 0-3.674-1.647-3.674-3.672s1.648-3.672 3.674-3.672 3.675 1.647 3.675 3.672-1.65 3.672-3.68 3.672zm0-5.356c-.93 0-1.685.755-1.685 1.684a1.68 1.68 0 1 0 3.36 0c0-.93-.76-1.684-1.69-1.684z"
                                ></path>
                                <circle
                                    cx="271.221"
                                    cy="221.715"
                                    r="2.68"
                                    fill="#857B98"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M271.22 225.387c-2.025 0-3.673-1.647-3.673-3.672a3.677 3.677 0 0 1 7.354 0 3.677 3.677 0 0 1-3.67 3.672zm0-5.356a1.69 1.69 0 0 0 0 3.38c.93 0 1.69-.75 1.69-1.68 0-.93-.75-1.68-1.68-1.68z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M263.578 218.66l7.643-14.633"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M263.577 219.654a.99.99 0 0 1-.88-1.453l7.64-14.63c.255-.48.856-.67 1.343-.42.487.26.675.86.422 1.34l-7.642 14.64a1 1 0 0 1-.883.54z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M271.22 221.715l6.76-13.666"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M271.22 222.71a.994.994 0 0 1-.89-1.436l6.758-13.667a.997.997 0 0 1 1.333-.45c.5.244.7.84.46 1.332l-6.76 13.66c-.17.35-.52.55-.89.55z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M278.864 224.77l6.237-12.696"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M278.863 225.764a.995.995 0 0 1-.892-1.432l6.24-12.696a.992.992 0 0 1 1.33-.454c.5.242.7.838.46 1.33l-6.23 12.696a.983.983 0 0 1-.89.556z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M329.028 237.18c-.237.458-.504.91-.803 1.352-4.586 6.966-15.668 10.388-30.83 11.472-31.428 2.26-72.042.996-85.196.194-1.08-.07-1.83-1.398-1.56-2.742l.98-6.686c.19-.932.88-1.55 1.63-1.482l2.27.206 35.77 3.26 16.56 1.506c21.8 1.566 45.37 3.52 59.06-6.385.29-.206.57-.412.85-.626.1-.09.2-.16.3-.25.2-.16.39-.32.58-.48.33-.28.58.25.38.65z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M255.398 252.776c-18.403 0-34.975-.582-43.29-1.09-.865-.054-1.65-.49-2.213-1.226-.684-.894-.95-2.13-.71-3.302l.965-6.603c.36-1.768 1.703-2.898 3.24-2.752l56.076 5.08c21.456 1.545 43.644 3.146 56.577-6.214.283-.21.55-.4.807-.6l.253-.21c.223-.18.388-.32.553-.45.68-.57 1.578-.59 2.22-.09.714.56.922 1.64.485 2.51v.01c-.26.51-.56 1.01-.89 1.5-4.57 6.94-15.03 10.91-31.96 12.12-13.22.95-28.19 1.28-42.1 1.28zM213.21 240.78a.71.71 0 0 0-.123.29l-.963 6.602c-.117.583.098.987.212 1.05 14.49.875 54.396 1.993 84.95-.205 10.984-.785 19.17-2.797 24.464-5.998-13.878 6.12-33.468 4.7-52.5 3.33l-1.504-.11-54.535-4.97z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M423.38 146.91l-10.804-8.525a3 3 0 0 0-3.72 0l-10.806 8.523a3.01 3.01 0 0 0-1.143 2.356v30.77a3.007 3.007 0 0 0 3.004 3.003l21.62-.002a3.005 3.005 0 0 0 3.01-3.002v-30.767c0-.918-.42-1.788-1.14-2.356z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M399.91 184.03a4.008 4.008 0 0 1-4-3.993v-30.772c0-1.228.555-2.37 1.52-3.136l10.81-8.53a3.973 3.973 0 0 1 4.953 0l10.802 8.52c.967.76 1.523 1.9 1.523 3.13v30.76c0 1.07-.417 2.07-1.173 2.83a3.98 3.98 0 0 1-2.82 1.17H399.91zm10.806-45.3a2 2 0 0 0-1.243.435l-10.808 8.523c-.485.384-.764.96-.764 1.576v30.77a2.025 2.025 0 0 0 2.01 2.008l21.61-.002h.01c.54 0 1.04-.208 1.42-.586.38-.38.59-.884.59-1.42v-30.768c0-.61-.28-1.2-.76-1.574l-10.8-8.526c-.36-.29-.8-.435-1.24-.435z"
                                ></path>
                                <path
                                    fill="#B9BAD5"
                                    d="M401.912 160.848h17.606m-17.608-.498h17.608v.995H401.91zm3.783 4.098h13.825m-13.824-.498h13.825v.995h-13.83z"
                                ></path>
                                <g fill="#B9BAD5">
                                    <circle
                                        cx="402.713"
                                        cy="164.448"
                                        r="1.177"
                                    ></circle>
                                    <path
                                        d="M402.713 166.12a1.67 1.67 0 0 1-1.184-.49c-.32-.314-.5-.735-.5-1.182s.17-.868.49-1.183c.65-.65 1.71-.653 2.37 0 .31.315.49.736.49 1.183s-.18.868-.49 1.183c-.33.33-.76.49-1.19.49zm0-2.35a.677.677 0 0 0-.48 1.157.68.68 0 1 0 .48-1.158z"
                                    ></path>
                                </g>
                                <g fill="#B9BAD5">
                                    <path
                                        d="M418.766 178.778h-16.102a.376.376 0 0 1-.376-.376v-3.83c0-.208.17-.376.376-.376h16.102c.208 0 .376.168.376.376v3.83a.376.376 0 0 1-.376.376z"
                                    ></path>
                                    <path
                                        d="M418.767 179.275h-16.103a.875.875 0 0 1-.874-.874v-3.82c0-.48.392-.87.874-.87h16.103c.482 0 .873.39.873.88v3.83c0 .48-.392.88-.873.88zm-15.982-.994h15.86v-3.58h-15.86v3.59z"
                                    ></path>
                                </g>
                                <circle
                                    cx="410.715"
                                    cy="150.056"
                                    r="2.993"
                                    fill="#5F5371"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M401.882 171.31h-.995a.496.496 0 1 1 0-.993h.995a.496.496 0 1 1-.003.994zm15.703 0h-1.963a.496.496 0 1 1 0-.993h1.963a.496.496 0 1 1 0 .994zm-3.926 0h-1.97c-.28 0-.5-.22-.5-.496 0-.275.22-.497.49-.497h1.96c.27 0 .49.222.49.497s-.22.497-.5.497zm-3.93 0h-1.97c-.28 0-.5-.22-.5-.496 0-.275.22-.497.49-.497h1.96c.27 0 .49.222.49.497s-.23.497-.5.497zm-3.93 0h-1.97c-.28 0-.5-.22-.5-.496 0-.275.22-.497.49-.497h1.96c.27 0 .49.222.49.497s-.22.497-.5.497zm14.73 0h-1c-.28 0-.5-.22-.5-.496 0-.275.22-.497.49-.497h.99c.27 0 .49.222.49.497s-.23.497-.5.497z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M410.715 148.536V99.46"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M410.715 149.53a.994.994 0 0 1-.995-.994V99.46a.994.994 0 1 1 1.99 0v49.07a.99.99 0 0 1-.995.99z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M178.478 245.983h-6.91a1.492 1.492 0 0 1-1.492-1.49v-14.34c0-.822.668-1.49 1.492-1.49h6.91c2.62 0 4.75 2.13 4.75 4.747v7.826a4.754 4.754 0 0 1-4.75 4.747zM173.06 243h5.418c.974 0 1.766-.79 1.766-1.765v-7.826c0-.98-.793-1.77-1.766-1.77h-5.418V243z"
                                ></path>
                                <g fill="#D6696F">
                                    <path
                                        d="M166.955 251.283H148.21c-2.547 0-4.612-2.344-4.612-5.236v-21.37h27.97v21.37c0 2.892-2.065 5.236-4.613 5.236z"
                                    ></path>
                                    <path
                                        d="M166.955 252.774H148.21c-3.366 0-6.104-3.018-6.104-6.727v-21.37c0-.823.668-1.49 1.492-1.49h27.97c.825 0 1.493.667 1.493 1.49v21.37c0 3.71-2.73 6.727-6.1 6.727zm-21.866-26.606v19.88c0 2.064 1.4 3.744 3.12 3.744h18.74c1.72 0 3.12-1.68 3.12-3.745v-19.88h-24.98z"
                                    ></path>
                                </g>
                                <path
                                    fill="#FFF"
                                    d="M173.31 223.516h-31.76"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M173.31 225.007h-31.76a1.492 1.492 0 1 1 0-2.982h31.762a1.492 1.492 0 1 1 0 2.982z"
                                ></path>
                                <path
                                    fill="#E68887"
                                    d="M146.046 246.538a.994.994 0 0 1-.995-.994V228.02c0-.55.45-.994 1-.994s1 .445 1 .994v17.524a.99.99 0 0 1-.99.994z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M516.508 253.27H1.492"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M516.508 254.762H1.492a1.492 1.492 0 1 1 0-2.982h515.016a1.492 1.492 0 1 1 0 2.982z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M249.35 229.926l-10.805-8.525a3.004 3.004 0 0 0-3.72 0l-10.806 8.53a2.99 2.99 0 0 0-1.15 2.36v30.77c0 1.66 1.34 3 3 3.01h21.61c1.66.01 3-1.34 3-3v-30.78c-.01-.91-.43-1.78-1.15-2.35z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M225.878 267.047a4.01 4.01 0 0 1-3.998-3.995V232.28a3.98 3.98 0 0 1 1.52-3.135l10.808-8.524a3.975 3.975 0 0 1 4.954.01l10.803 8.53a3.977 3.977 0 0 1 1.523 3.14v30.77c0 1.07-.417 2.08-1.174 2.83a3.98 3.98 0 0 1-2.82 1.17h-21.616zm10.806-45.3c-.438 0-.877.144-1.242.433l-10.807 8.524a2 2 0 0 0-.765 1.575v30.77c0 1.1.903 2 2.01 2l21.61-.01h.003c.536 0 1.037-.21 1.416-.59.38-.38.59-.89.59-1.43v-30.76c0-.62-.28-1.2-.77-1.58l-10.81-8.53c-.37-.29-.81-.44-1.25-.44z"
                                ></path>
                                <path
                                    fill="#B9BAD5"
                                    d="M227.88 243.864h17.607m-17.607-.496h17.607v.994H227.88zm3.782 4.096h13.825m-13.825-.497h13.825v.994h-13.825z"
                                ></path>
                                <g fill="#B9BAD5">
                                    <circle
                                        cx="228.681"
                                        cy="247.464"
                                        r="1.177"
                                    ></circle>
                                    <path
                                        d="M228.682 249.138a1.67 1.67 0 0 1-1.675-1.674c0-.447.174-.867.49-1.182.632-.633 1.737-.633 2.37 0a1.665 1.665 0 0 1-.002 2.365c-.316.316-.736.49-1.183.49zm0-2.353a.667.667 0 0 0-.48.2.673.673 0 0 0 0 .96.693.693 0 0 0 .96 0 .673.673 0 0 0 0-.96c-.13-.13-.3-.2-.48-.2z"
                                    ></path>
                                </g>
                                <g fill="#B9BAD5">
                                    <path
                                        d="M244.735 261.794h-16.102a.376.376 0 0 1-.376-.376v-3.83c0-.208.17-.376.376-.376h16.102c.208 0 .376.168.376.376v3.83a.37.37 0 0 1-.37.376z"
                                    ></path>
                                    <path
                                        d="M244.735 262.29h-16.103a.873.873 0 0 1-.874-.872v-3.83c0-.48.392-.873.874-.873h16.103c.482 0 .874.39.874.873v3.83a.887.887 0 0 1-.88.873zm-15.982-.993h15.86v-3.588h-15.86v3.58z"
                                    ></path>
                                </g>
                                <circle
                                    cx="236.683"
                                    cy="233.072"
                                    r="2.993"
                                    fill="#5F5371"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M227.85 254.328h-.994a.496.496 0 0 1-.497-.497c0-.27.22-.49.49-.49h.99c.27 0 .49.22.49.5s-.22.5-.5.5zm15.703 0h-1.963a.494.494 0 0 1 0-.987h1.963c.275 0 .497.22.497.5s-.222.5-.497.5zm-3.926 0h-1.963a.494.494 0 0 1 0-.987h1.963c.275 0 .497.22.497.5s-.222.5-.497.5zm-3.925 0h-1.963c-.28 0-.5-.222-.5-.497 0-.27.22-.49.49-.49h1.96c.27 0 .49.22.49.5s-.23.5-.5.5zm-3.926 0h-1.963a.494.494 0 0 1 0-.987h1.963c.275 0 .497.22.497.5s-.222.5-.497.5zm14.734 0h-.995a.494.494 0 0 1 0-.987h.995c.275 0 .497.22.497.5s-.222.5-.497.5z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M236.683 231.552v-19.236"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M236.683 232.546a.994.994 0 0 1-.995-.994v-19.235a.994.994 0 1 1 1.99 0v19.235c0 .55-.445.994-.995.994z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M122.837 233.316l-8.253-6.512a2.293 2.293 0 0 0-2.842 0l-8.255 6.51c-.55.436-.873 1.1-.873 1.8v23.505a2.297 2.297 0 0 0 2.294 2.29h16.508a2.297 2.297 0 0 0 2.294-2.3v-23.5c0-.7-.32-1.37-.873-1.8z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M104.91 261.906a3.297 3.297 0 0 1-3.29-3.285v-23.5c0-1.01.456-1.95 1.25-2.58l8.257-6.51c1.2-.94 2.875-.94 4.075 0l8.252 6.52a3.273 3.273 0 0 1 1.252 2.58v23.5c0 .88-.343 1.71-.965 2.33-.62.62-1.44.96-2.32.96h-16.5zm8.253-34.603c-.284 0-.567.093-.803.28l-8.256 6.512c-.314.25-.495.62-.495 1.02v23.505c0 .714.58 1.298 1.3 1.3l16.5-.003c.34 0 .67-.134.91-.38.24-.245.38-.57.38-.92v-23.5c0-.396-.19-.777-.5-1.02l-8.26-6.512a1.32 1.32 0 0 0-.81-.282z"
                                ></path>
                                <path
                                    fill="#B9BAD5"
                                    d="M106.438 243.963h13.45m-13.45-.497h13.45v.994h-13.45zm2.888 3.247h10.56m-10.56-.497h10.56v.994h-10.56z"
                                ></path>
                                <g fill="#B9BAD5">
                                    <circle
                                        cx="107.05"
                                        cy="246.713"
                                        r=".899"
                                    ></circle>
                                    <path
                                        d="M107.05 248.11a1.393 1.393 0 0 1-1.396-1.397c0-.373.145-.723.408-.987a1.4 1.4 0 0 1 1.975 0c.263.264.408.614.408.987s-.145.723-.41.986c-.26.26-.612.41-.985.41zm0-1.8a.4.4 0 0 0-.284.685c.152.15.416.15.568 0a.4.4 0 0 0-.284-.684z"
                                    ></path>
                                </g>
                                <g fill="#B9BAD5">
                                    <path
                                        d="M119.313 257.66h-12.3a.288.288 0 0 1-.288-.288v-2.926c0-.16.13-.287.288-.287h12.3c.16 0 .288.12.288.28v2.92c0 .16-.13.28-.28.28z"
                                    ></path>
                                    <path
                                        d="M119.313 258.156h-12.3a.784.784 0 0 1-.785-.784v-2.926c0-.433.352-.784.785-.784h12.3c.433 0 .785.35.785.784v2.926a.785.785 0 0 1-.785.784zm-12.09-.994h11.88v-2.506h-11.88v2.506z"
                                    ></path>
                                </g>
                                <circle
                                    cx="113.162"
                                    cy="235.719"
                                    r="2.287"
                                    fill="#5F5371"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M106.65 252.073h-.995a.496.496 0 1 1 0-.994h.995c.275 0 .497.22.497.49s-.222.49-.497.49zm11.164 0h-1.86a.497.497 0 1 1 0-.994h1.86c.275 0 .497.22.497.49s-.22.49-.49.49zm-3.72 0h-1.862a.496.496 0 1 1 0-.994h1.86c.276 0 .498.22.498.49s-.222.49-.497.49zm-3.723 0h-1.86c-.27 0-.49-.222-.49-.497s.22-.497.5-.497h1.86c.28 0 .5.22.5.49s-.22.49-.5.49zm10.3 0h-.99c-.27 0-.49-.222-.49-.497s.22-.497.5-.497h1c.28 0 .5.22.5.49s-.22.49-.49.49z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M113.162 234.558v-20.57"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M113.163 235.553a.994.994 0 0 1-.995-.994v-20.58c0-.55.445-1 .995-1s.995.44.995.99v20.57a.99.99 0 0 1-.995.99z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M488.852 238.165l-8.253-6.512a2.304 2.304 0 0 0-2.85 0l-8.26 6.51c-.55.436-.88 1.1-.88 1.8v23.505a2.29 2.29 0 0 0 2.29 2.293h16.51c1.27 0 2.29-1.02 2.29-2.29v-23.5c0-.7-.32-1.36-.88-1.8z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M470.923 266.756a3.3 3.3 0 0 1-3.29-3.285v-23.5c0-1.01.457-1.95 1.25-2.58l8.258-6.51c1.2-.94 2.88-.94 4.08 0l8.25 6.52c.8.63 1.25 1.57 1.25 2.58v23.5c0 .88-.34 1.71-.96 2.33-.62.62-1.44.96-2.32.96h-16.51zm8.254-34.604c-.284 0-.566.093-.803.28l-8.256 6.512c-.314.25-.494.62-.494 1.02v23.505c0 .71.585 1.29 1.302 1.29h16.508c.347 0 .67-.14.916-.38.247-.25.382-.57.382-.92v-23.5c0-.4-.185-.78-.493-1.02h-.01l-8.26-6.51c-.24-.19-.53-.28-.81-.28z"
                                ></path>
                                <path
                                    fill="#B9BAD5"
                                    d="M472.452 248.813h13.45m-13.45-.498h13.45v.994h-13.45zm2.888 3.247h10.562m-10.562-.497h10.56v.994h-10.56z"
                                ></path>
                                <g fill="#B9BAD5">
                                    <circle
                                        cx="473.064"
                                        cy="251.562"
                                        r=".899"
                                    ></circle>
                                    <path
                                        d="M473.065 252.958a1.397 1.397 0 1 1 .987-.41c-.264.26-.613.4-.987.4zm0-1.797a.406.406 0 0 0 0 .81c.107 0 .208-.04.283-.12a.38.38 0 0 0 .12-.28c0-.1-.044-.21-.12-.28a.39.39 0 0 0-.283-.12z"
                                    ></path>
                                </g>
                                <g fill="#B9BAD5">
                                    <path
                                        d="M485.327 262.51h-12.3a.288.288 0 0 1-.288-.288v-2.926c0-.16.12-.287.28-.287h12.3c.16 0 .29.12.29.28v2.92c0 .16-.13.28-.29.28z"
                                    ></path>
                                    <path
                                        d="M485.327 263.006h-12.3a.784.784 0 0 1-.785-.784v-2.926c0-.433.352-.784.785-.784h12.3c.433 0 .785.35.785.784v2.926a.785.785 0 0 1-.785.784zm-12.09-.994h11.88v-2.506h-11.88v2.506z"
                                    ></path>
                                </g>
                                <circle
                                    cx="479.177"
                                    cy="240.569"
                                    r="2.287"
                                    fill="#5F5371"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M472.664 256.923h-.995c-.28 0-.5-.222-.5-.497s.22-.497.49-.497h.99c.27 0 .49.22.49.49s-.22.49-.5.49zm11.166 0h-1.862a.496.496 0 1 1 .003-.994h1.86c.28 0 .5.22.5.49s-.22.49-.49.49zm-3.722 0h-1.86a.497.497 0 1 1 0-.994h1.86c.275 0 .497.22.497.49s-.222.49-.497.49zm-3.72 0h-1.862c-.275 0-.497-.222-.497-.497s.22-.497.49-.497h1.86c.27 0 .5.22.5.49s-.23.49-.5.49zm10.296 0h-.995c-.28 0-.5-.222-.5-.497s.22-.497.49-.497h.99c.27 0 .49.22.49.49s-.23.49-.5.49z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M479.177 239.408v-20.57"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M479.177 240.402a.994.994 0 0 1-.995-.994v-20.57a.994.994 0 1 1 1.99 0v20.57c0 .55-.445.994-.995.994z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M186.327 241.41l-8.253-6.512a2.293 2.293 0 0 0-2.842 0l-8.255 6.51c-.55.436-.873 1.1-.873 1.8v23.505a2.298 2.298 0 0 0 2.294 2.293l16.508-.002a2.29 2.29 0 0 0 2.294-2.293v-23.5c0-.7-.32-1.36-.873-1.8z"
                                ></path>
                                <path
                                    fill="#5F5371"
                                    d="M168.398 270a3.297 3.297 0 0 1-3.29-3.285v-23.507c0-1.01.457-1.95 1.252-2.58l8.256-6.51a3.274 3.274 0 0 1 4.076 0l8.25 6.51a3.264 3.264 0 0 1 1.253 2.58v23.503c0 .88-.342 1.71-.964 2.33-.62.62-1.44.96-2.32.96H168.4zm8.255-34.604c-.284 0-.567.094-.803.282l-8.256 6.51a1.3 1.3 0 0 0-.495 1.02v23.506c0 .715.58 1.298 1.3 1.3l16.5-.002a1.298 1.298 0 0 0 1.3-1.3V243.21c0-.395-.19-.776-.5-1.018l-8.26-6.512c-.24-.19-.53-.284-.81-.284z"
                                ></path>
                                <path
                                    fill="#B9BAD5"
                                    d="M169.928 252.057h13.45m-13.45-.497h13.45v.995h-13.45zm2.888 3.247h10.56m-10.56-.497h10.56v.994h-10.56z"
                                ></path>
                                <g fill="#B9BAD5">
                                    <circle
                                        cx="170.54"
                                        cy="254.807"
                                        r=".899"
                                    ></circle>
                                    <path
                                        d="M170.54 256.2a1.39 1.39 0 0 1-1.397-1.394c0-.373.146-.723.41-.986.526-.528 1.447-.53 1.975 0 .263.263.408.613.408.986a1.39 1.39 0 0 1-1.396 1.395zm0-1.795a.404.404 0 0 0-.402.4.403.403 0 0 0 .804 0 .4.4 0 0 0-.402-.4z"
                                    ></path>
                                </g>
                                <g fill="#B9BAD5">
                                    <path
                                        d="M182.802 265.753h-12.3a.288.288 0 0 1-.288-.287v-2.926c0-.16.13-.287.288-.287h12.3c.16 0 .288.13.288.287v2.926c0 .16-.13.287-.288.287z"
                                    ></path>
                                    <path
                                        d="M182.803 266.25h-12.3a.784.784 0 0 1-.785-.784v-2.926c0-.433.352-.784.785-.784h12.3c.433 0 .785.35.785.784v2.926a.785.785 0 0 1-.785.784zm-12.09-.994h11.88v-2.506h-11.88v2.506z"
                                    ></path>
                                </g>
                                <circle
                                    cx="176.652"
                                    cy="243.814"
                                    r="2.287"
                                    fill="#5F5371"
                                ></circle>
                                <path
                                    fill="#5F5371"
                                    d="M170.14 260.167h-.995a.496.496 0 1 1 0-.994h.995a.496.496 0 1 1 0 .994zm11.164 0h-1.86a.497.497 0 1 1 0-.994h1.86a.497.497 0 0 1 .007.994zm-3.72 0h-1.862a.496.496 0 1 1 0-.994h1.86a.497.497 0 1 1 0 .994zm-3.722 0h-1.86a.497.497 0 1 1 0-.994h1.87c.28 0 .5.222.5.497s-.22.497-.49.497zm10.298 0h-.996a.496.496 0 1 1 0-.994h.995c.27 0 .49.222.49.497s-.22.497-.5.497z"
                                ></path>
                                <path
                                    fill="#FFF"
                                    d="M176.652 242.652V226.31"
                                ></path>
                                <path
                                    fill="#FBB563"
                                    d="M176.652 243.646a.994.994 0 0 1-.995-.994V226.31a.994.994 0 1 1 1.99 0v16.342c0 .55-.446.994-.995.994z"
                                ></path>
                            </svg>
                        </div>
                    </div>
                    <div class="empty-displayTmpl-btn">
                        <a
                            class="btn btn-primary btn-lg"
                            href="{{ route('products.create') }}"
                        >{{ trans('plugins/ecommerce::products.add_new_product') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
